package cn.godmao.getty.client.base;

import cn.godmao.getty.GettyCommon;
import cn.godmao.common.Init;
import cn.godmao.getty.handler.IChannelHandler;
import cn.godmao.getty.client.AbstractClient;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.timeout.IdleStateEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.time.LocalDateTime;

public class ClientBaseHandler extends ChannelInboundHandlerAdapter implements IChannelHandler, Init.Init1<AbstractClient> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private AbstractClient abstractClient;

    @Override
    public void init(AbstractClient abstractClient) {
        this.abstractClient = abstractClient;
    }


    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        abstractClient.onError(cause);
    }


    @Override
    public void channelInactive(ChannelHandlerContext ctx) {
        abstractClient.onClose();
        if (abstractClient.getConfig().isReconnect()) {
            abstractClient.connect();
        }
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) {
        abstractClient.onOpen();
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        abstractClient.onMessage(msg);
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        if (IdleStateEvent.FIRST_ALL_IDLE_STATE_EVENT.equals(evt)) {
            log.debug("FIRST_ALL_IDLE_STATE_EVENT {}", evt);
            GettyCommon.close(ctx.channel());
        } else if (IdleStateEvent.WRITER_IDLE_STATE_EVENT.equals(evt)) {
            log.debug("WRITER_IDLE_STATE_EVENT {} {}", LocalDateTime.now(), evt);
        } else if (IdleStateEvent.ALL_IDLE_STATE_EVENT.equals(evt)) {
            log.debug("ALL_IDLE_STATE_EVENT {}", evt);
        } else if (IdleStateEvent.FIRST_READER_IDLE_STATE_EVENT.equals(evt)) {
            log.debug("FIRST_READER_IDLE_STATE_EVENT {}", evt);
        } else if (IdleStateEvent.FIRST_WRITER_IDLE_STATE_EVENT.equals(evt)) {
            log.debug("FIRST_WRITER_IDLE_STATE_EVENT {}", evt);
        } else if (IdleStateEvent.READER_IDLE_STATE_EVENT.equals(evt)) {
            log.debug("READER_IDLE_STATE_EVENT {}", evt);
        } else {
            log.debug("IDLE_STATE_EVENT {}", evt);
        }
    }
}
