package cn.godmao.getty;

import cn.godmao.getty.channel.IChannel;
import io.netty.channel.Channel;
import io.netty.util.concurrent.EventExecutor;

public abstract class AbstractChannel implements IChannel<Object> {
    private final Channel channel;
    private Object id;
    private EventExecutor executor;
    private boolean authorization;
    
    public AbstractChannel(Object id, Channel channel, EventExecutor executor) {
        this.id = id;
        this.channel = channel;
        this.executor = executor;
    }

    @Override
    public Object getId() {
        return id;
    }

    @Override
    public Channel getChannel() {
        return channel;
    }

    @Override
    public EventExecutor getExecutor() {
        return executor;
    }

    @Override
    public void setId(Object id) {
        this.id = id;
    }

    @Override
    public void setExecutor(EventExecutor executor) {
        this.executor = executor;
    }

    @Override
    public void setAuthorization(boolean authorization) {
        this.authorization = authorization;
    }

    @Override
    public boolean isAuthorization() {
        return authorization;
    }

}
