package cn.godmao.getty.server_websocket.client.base;

import cn.godmao.getty.common.GettyCommon;
import cn.godmao.common.Init;
import cn.godmao.getty.common.handler.IChannelHandler;
import cn.godmao.getty.server_websocket.client.AbstractWebsocketClient;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.websocketx.WebSocketClientProtocolHandler;
import io.netty.handler.timeout.IdleStateEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.time.LocalDateTime;

public class WebsocketClientBaseHandler extends ChannelInboundHandlerAdapter implements IChannelHandler, Init.Init1<AbstractWebsocketClient> {
    public final Logger log = LoggerFactory.getLogger(this.getClass());

    private AbstractWebsocketClient server;

    @Override
    public void init(AbstractWebsocketClient server) {
        this.server = server;
    }


    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        server.onError(cause);
        super.exceptionCaught(ctx, cause);
    }


    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        server.onClose();
        super.channelInactive(ctx);
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        server.onMessage(msg);
        super.channelRead(ctx, msg);
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (IdleStateEvent.FIRST_ALL_IDLE_STATE_EVENT.equals(evt)) {
            log.debug("FIRST_ALL_IDLE_STATE_EVENT {}", evt);
            GettyCommon.close(ctx.channel());
        } else if (IdleStateEvent.WRITER_IDLE_STATE_EVENT.equals(evt)) {
            log.debug("WRITER_IDLE_STATE_EVENT {} {}", LocalDateTime.now(), evt);
        } else if (IdleStateEvent.ALL_IDLE_STATE_EVENT.equals(evt)) {
            log.debug("ALL_IDLE_STATE_EVENT {}", evt);
        } else if (IdleStateEvent.FIRST_READER_IDLE_STATE_EVENT.equals(evt)) {
            log.debug("FIRST_READER_IDLE_STATE_EVENT {}", evt);
        } else if (IdleStateEvent.FIRST_WRITER_IDLE_STATE_EVENT.equals(evt)) {
            log.debug("FIRST_WRITER_IDLE_STATE_EVENT {}", evt);
        } else if (IdleStateEvent.READER_IDLE_STATE_EVENT.equals(evt)) {
            log.debug("READER_IDLE_STATE_EVENT {}", evt);
        } else if (WebSocketClientProtocolHandler.ClientHandshakeStateEvent.HANDSHAKE_COMPLETE.equals(evt)) {
            log.debug("HANDSHAKE_COMPLETE_EVENT {}", evt);// 握手成功
            server.onOpen();
        } else if (WebSocketClientProtocolHandler.ClientHandshakeStateEvent.HANDSHAKE_TIMEOUT.equals(evt)) {
            log.debug("HANDSHAKE_TIMEOUT_EVENT {}", evt);// 握手超时
        } else if (WebSocketClientProtocolHandler.ClientHandshakeStateEvent.HANDSHAKE_ISSUED.equals(evt)) {
            log.debug("HANDSHAKE_ISSUED_EVENT {}", evt);// 发送握手
        } else {
            log.debug("IDLE_STATE_EVENT {}", evt);
        }
        super.userEventTriggered(ctx, evt);
    }
}
