package cn.godmao.getty.server_websocket.client.base;

import cn.godmao.common.Init;
import cn.godmao.getty.common.handler.IEncoderHandler;
import cn.godmao.getty.server_websocket.client.AbstractWebsocketClient;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;

import java.util.List;

public class WebsocketClientBaseEncoderHandler extends MessageToMessageEncoder<TextWebSocketFrame> implements IEncoderHandler, Init.Init1<AbstractWebsocketClient> {
    private AbstractWebsocketClient server;

    @Override
    public void init(AbstractWebsocketClient server) {
        this.server = server;
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, TextWebSocketFrame msg, List<Object> out) throws Exception {
        Object obj = server.getEncoder().encode(msg);
        if (null != obj) {
            out.add(obj);
        }
    }
}
