package cn.godmao.getty.server_websocket.client;

import cn.godmao.common.Init;
import cn.godmao.getty.server.InitBaseChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.WebSocketClientProtocolConfig;
import io.netty.handler.codec.http.websocketx.WebSocketClientProtocolHandler;
import io.netty.handler.codec.http.websocketx.extensions.compression.WebSocketClientCompressionHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.handler.stream.ChunkedWriteHandler;

public class WebsocketClientInitializer extends ChannelInitializer<Channel> implements Init.Init1<AbstractWebsocketClient> {

    private AbstractWebsocketClient server;

    @Override
    public void init(AbstractWebsocketClient server) {
        this.server = server;
    }

    @Override
    protected void initChannel(Channel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();

        if (server.getPort().equals(443)) {
            final SslContext sslCtx = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build();
            pipeline.addLast(sslCtx.newHandler(ch.alloc(), server.getHost(), server.getPort()));
        }

        // websocket
        pipeline.addLast(new HttpClientCodec());
        pipeline.addLast(new HttpObjectAggregator(65536));
        pipeline.addLast(new ChunkedWriteHandler());
        pipeline.addLast(WebSocketClientCompressionHandler.INSTANCE);
        pipeline.addLast(new WebSocketClientProtocolHandler(
                WebSocketClientProtocolConfig.newBuilder()
                        .webSocketUri(server.getUri())
                        .allowExtensions(true)
                        .maxFramePayloadLength(Integer.MAX_VALUE)
                        .build()
        ));
        InitBaseChannel.initChannel(pipeline, server);
    }
}
