package cn.godmao.getty.server_websocket.client;

import cn.godmao.getty.common.IConfig;
import cn.godmao.getty.common.codec.IDecoder;
import cn.godmao.getty.common.codec.IEncoder;
import cn.godmao.getty.common.handler.IChannelHandler;
import cn.godmao.getty.common.handler.IDecoderHandler;
import cn.godmao.getty.common.handler.IEncoderHandler;
import cn.godmao.getty.common.handler.IFilterHandler;
import cn.godmao.utils.CollectUtil;
import cn.godmao.getty.server_websocket.client.base.*;
import io.netty.channel.Channel;
import io.netty.channel.ChannelInitializer;
import io.netty.util.concurrent.EventExecutorGroup;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;

public class WebsocketClientConfig implements IConfig {
    private String host;
    private Integer port;
    private String uri;
    private Integer workTheard = 1;
    private String workTheardName = "c-work";

    //
    private Boolean addIdleHandler = false;
    private Boolean addUnpacker = true;
    private EventExecutorGroup encoderHandlerLoopGroup;
    private EventExecutorGroup decoderHandlerLoopGroup;
    private EventExecutorGroup serviceHandlerLoopGroup;
    private Class<? extends IEncoder<?, ?>> encoderClass = WebsocketClientBaseEncoder.class;
    private Class<? extends IDecoder<?, ?>> decoderClass = WebsocketClientBaseDecoder.class;
    private Class<? extends ChannelInitializer<Channel>> channelInitializerClass = WebsocketClientInitializer.class;
    private Collection<Class<? extends IChannelHandler>> channelHandlerClass = CollectUtil.listOf(WebsocketClientBaseHandler.class);
    private Collection<Class<? extends IFilterHandler>> filterHandlerClass = CollectUtil.listOf();
    private Collection<Class<? extends IDecoderHandler>> decoderHandlerClass = CollectUtil.listOf(WebsocketClientBaseDecoderHandler.class);
    private Collection<Class<? extends IEncoderHandler>> encoderHandlerClass = CollectUtil.listOf(WebsocketClientBaseEncoderHandler.class);
    private Collection<Class<?>> messageClass = new ArrayList<>();

    public WebsocketClientConfig(String uri) {
        this.uri = uri;
        URI uri_ = URI.create(uri);
        this.host = uri_.getHost();
        this.port = (uri_.getPort() == -1) ? 443 : uri_.getPort();
    }

    @Override
    public Boolean getAddIdleHandler() {
        return addIdleHandler;
    }

    @Override
    public Boolean getAddUnpacker() {
        return addUnpacker;
    }

    @Override
    public Class<? extends IEncoder<?, ?>> getEncoderClass() {
        return encoderClass;
    }

    @Override
    public Class<? extends IDecoder<?, ?>> getDecoderClass() {
        return decoderClass;
    }

    @Override
    public Class<? extends ChannelInitializer<Channel>> getChannelInitializerClass() {
        return channelInitializerClass;
    }

    @Override
    public Collection<Class<? extends IFilterHandler>> getFilterHandlerClass() {
        return filterHandlerClass;
    }

    @Override
    public Collection<Class<? extends IDecoderHandler>> getDecoderHandlerClass() {
        return decoderHandlerClass;
    }

    @Override
    public Collection<Class<? extends IEncoderHandler>> getEncoderHandlerClass() {
        return encoderHandlerClass;
    }

    @Override
    public Collection<Class<? extends IChannelHandler>> getChannelHandlerClass() {
        return channelHandlerClass;
    }

    public String getHost() {
        return host;
    }

    public Integer getPort() {
        return port;
    }

    public String getUri() {
        return uri;
    }

    public Integer getWorkTheard() {
        return workTheard;
    }

    public String getWorkTheardName() {
        return workTheardName;
    }

    public void setWorkTheard(Integer workTheard) {
        this.workTheard = workTheard;
    }

    public void setWorkTheardName(String workTheardName) {
        this.workTheardName = workTheardName;
    }

    @Override
    public EventExecutorGroup getEncoderHandlerLoopGroup() {
        return encoderHandlerLoopGroup;
    }

    public void setEncoderHandlerLoopGroup(EventExecutorGroup encoderHandlerLoopGroup) {
        this.encoderHandlerLoopGroup = encoderHandlerLoopGroup;
    }

    @Override
    public EventExecutorGroup getDecoderHandlerLoopGroup() {
        return decoderHandlerLoopGroup;
    }

    public void setDecoderHandlerLoopGroup(EventExecutorGroup decoderHandlerLoopGroup) {
        this.decoderHandlerLoopGroup = decoderHandlerLoopGroup;
    }

    @Override
    public EventExecutorGroup getServiceHandlerLoopGroup() {
        return serviceHandlerLoopGroup;
    }

    public void setServiceHandlerLoopGroup(EventExecutorGroup serviceHandlerLoopGroup) {
        this.serviceHandlerLoopGroup = serviceHandlerLoopGroup;
    }

    @Override
    public Collection<Class<?>> getMessageClass() {
        return messageClass;
    }
}
