package cn.godmao.getty.server.server.base;

import cn.godmao.getty.common.codec.IEncoder;
import cn.godmao.getty.common.handler.IEncoderHandler;
import cn.godmao.common.Init;
import cn.godmao.getty.server.server.AbstractServer;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;

import java.util.List;


public class ServerBaseEncoderHandler extends MessageToMessageEncoder<Object> implements IEncoderHandler, Init.Init1<AbstractServer<?>> {
    private IEncoder<Object, Object> encoder;

    @Override
    public void init(AbstractServer<?> abstractServer) {
        this.encoder = abstractServer.getEncoder();
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, Object msg, List<Object> out) {
        Object obj = encoder.encode(msg);
        if (null != obj) {
            out.add(obj);
        }
    }
}

