package cn.godmao.getty.server.server.base;

import cn.godmao.getty.common.codec.IDecoder;
import cn.godmao.getty.common.handler.IDecoderHandler;
import cn.godmao.common.Init;
import cn.godmao.getty.server.server.AbstractServer;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;

import java.util.List;

public class ServerBaseDecoderHandler extends MessageToMessageDecoder<ByteBuf> implements IDecoderHandler, Init.Init1<AbstractServer<?>> {
    private IDecoder<Object, Object> decoder;

    @Override
    public void init(AbstractServer<?> abstractServer) {
        this.decoder = abstractServer.getDecoder();
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf msg, List<Object> out) throws ClassNotFoundException {
        Object data = decoder.decode(msg);
        if (null == data) {
            return;
        }
        out.add(data);
    }
}
