package cn.godmao.getty.server.server;

import cn.godmao.getty.common.IConfig;
import cn.godmao.getty.common.channel.IChannelService;
import cn.godmao.getty.common.codec.IDecoder;
import cn.godmao.getty.common.codec.IEncoder;
import cn.godmao.getty.common.handler.IChannelHandler;
import cn.godmao.getty.common.handler.IDecoderHandler;
import cn.godmao.getty.common.handler.IEncoderHandler;
import cn.godmao.getty.common.handler.IFilterHandler;
import cn.godmao.getty.server.server.base.*;
import cn.godmao.utils.CollectUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelInitializer;
import io.netty.util.NettyRuntime;
import io.netty.util.concurrent.EventExecutorGroup;

import java.util.*;

public class ServerConfig implements IConfig {
    private Integer port;
    //    private String path;
    private Integer workTheard = 1; // fixme
    private String workTheardName = "s-work";
    private Integer userTheard = NettyRuntime.availableProcessors() * 2;
    private String userTheardName = "s-user";
    private Class<? extends ChannelInitializer<Channel>> channelInitializerClass = ServerBaseInitializer.class;

    //
    private Boolean addIdleHandler = false;
    private Boolean addUnpacker = true;
    private EventExecutorGroup encoderHandlerLoopGroup;
    private EventExecutorGroup decoderHandlerLoopGroup;
    private EventExecutorGroup serviceHandlerLoopGroup;
    private Class<? extends IEncoder<?, ?>> encoderClass = ServerBaseEncoder.class;
    private Class<? extends IDecoder<?, ?>> decoderClass = ServerBaseDecoder.class;
    private Collection<Class<? extends IChannelHandler>> channelHandlerClass = CollectUtil.listOf(ServerBaseHandler.class);
    private Collection<Class<? extends IFilterHandler>> filterHandlerClass = CollectUtil.listOf();
    private Collection<Class<? extends IDecoderHandler>> decoderHandlerClass = CollectUtil.listOf(ServerBaseDecoderHandler.class);
    private Collection<Class<? extends IEncoderHandler>> encoderHandlerClass = CollectUtil.listOf(ServerBaseEncoderHandler.class);
    private Collection<Class<?>> messageClass = new ArrayList<>();
    //
    private Class<? extends IChannelService<?, ?>> channelServiceClass = ServerChannelService.class;

    public ServerConfig(Integer port) {
        this.port = port;
    }

    public Integer getPort() {
        return port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public Integer getWorkTheard() {
        return workTheard;
    }

    public void setWorkTheard(Integer workTheard) {
        this.workTheard = workTheard;
    }

    public String getWorkTheardName() {
        return workTheardName;
    }

    public void setWorkTheardName(String workTheardName) {
        this.workTheardName = workTheardName;
    }

    public Integer getUserTheard() {
        return userTheard;
    }

    public void setUserTheard(Integer userTheard) {
        this.userTheard = userTheard;
    }

    public String getUserTheardName() {
        return userTheardName;
    }

    public void setUserTheardName(String userTheardName) {
        this.userTheardName = userTheardName;
    }


    @Override
    public Collection<Class<? extends IFilterHandler>> getFilterHandlerClass() {
        return filterHandlerClass;
    }

    @Override
    public Collection<Class<? extends IDecoderHandler>> getDecoderHandlerClass() {
        return decoderHandlerClass;
    }

    @Override
    public Collection<Class<? extends IEncoderHandler>> getEncoderHandlerClass() {
        return encoderHandlerClass;
    }

    @Override
    public Collection<Class<? extends IChannelHandler>> getChannelHandlerClass() {
        return channelHandlerClass;
    }

    @Override
    public Class<? extends ChannelInitializer<Channel>> getChannelInitializerClass() {
        return channelInitializerClass;
    }

    public void setChannelInitializerClass(Class<? extends ChannelInitializer<Channel>> channelInitializerClass) {
        this.channelInitializerClass = channelInitializerClass;
    }

    public Class<? extends IChannelService<?, ?>> getChannelServiceClass() {
        return channelServiceClass;
    }

    public void setChannelServiceClass(Class<? extends IChannelService<?, ?>> channelServiceClass) {
        this.channelServiceClass = channelServiceClass;
    }

    @Override
    public Boolean getAddIdleHandler() {
        return addIdleHandler;
    }

    public void setAddIdleHandler(Boolean addIdleHandler) {
        this.addIdleHandler = addIdleHandler;
    }

    @Override
    public Class<? extends IEncoder<?, ?>> getEncoderClass() {
        return encoderClass;
    }

    public void setEncoderClass(Class<? extends IEncoder<?, ?>> encoderClass) {
        this.encoderClass = encoderClass;
    }


    @Override
    public Class<? extends IDecoder<?, ?>> getDecoderClass() {
        return decoderClass;
    }

    public void setDecoderClass(Class<? extends IDecoder<?, ?>> decoderClass) {
        this.decoderClass = decoderClass;
    }

    @Override
    public Boolean getAddUnpacker() {
        return addUnpacker;
    }

    public void setAddUnpacker(Boolean addUnpacker) {
        this.addUnpacker = addUnpacker;
    }

    @Override
    public EventExecutorGroup getEncoderHandlerLoopGroup() {
        return encoderHandlerLoopGroup;
    }

    public void setEncoderHandlerLoopGroup(EventExecutorGroup encoderHandlerLoopGroup) {
        this.encoderHandlerLoopGroup = encoderHandlerLoopGroup;
    }

    @Override
    public EventExecutorGroup getDecoderHandlerLoopGroup() {
        return decoderHandlerLoopGroup;
    }

    public void setDecoderHandlerLoopGroup(EventExecutorGroup decoderHandlerLoopGroup) {
        this.decoderHandlerLoopGroup = decoderHandlerLoopGroup;
    }

    @Override
    public EventExecutorGroup getServiceHandlerLoopGroup() {
        return serviceHandlerLoopGroup;
    }

    public void setServiceHandlerLoopGroup(EventExecutorGroup serviceHandlerLoopGroup) {
        this.serviceHandlerLoopGroup = serviceHandlerLoopGroup;
    }

    @Override
    public Collection<Class<?>> getMessageClass() {
        return messageClass;
    }
}
