package cn.godmao.getty.server.client.base;

import cn.godmao.common.Init;
import cn.godmao.getty.common.codec.IEncoder;
import cn.godmao.getty.common.handler.IEncoderHandler;
import cn.godmao.getty.server.client.AbstractClient;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;

import java.util.List;


public class ClientBaseEncoderHandler extends MessageToMessageEncoder<Object> implements IEncoderHandler, Init.Init1<AbstractClient> {
    private IEncoder<Object, Object> encoder;

    @Override
    public void init(AbstractClient server) {
        this.encoder = server.getEncoder();
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, Object msg, List<Object> out) {
        Object obj = encoder.encode(msg);
        if (null != obj) {
            out.add(obj);
        }
    }
}
