package cn.godmao.getty.server.client.base;

import cn.godmao.common.Init;
import cn.godmao.getty.common.codec.IDecoder;
import cn.godmao.getty.common.ProtostuffUtil;
import cn.godmao.getty.server.client.ClientConfig;
import cn.godmao.utils.CollectUtil;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.DecoderException;

import java.util.Map;

public class ClientBaseDecoder implements IDecoder<ByteBuf, Object>, Init.Init1<ClientConfig> {

    Map<String, ? extends Class<?>> classMap;

    @Override
    public void init(ClientConfig config) {
        this.classMap = CollectUtil.toMap(config.getMessageClass(), Class::getSimpleName);
    }

    @Override
    public Object decode(ByteBuf byteBuf) throws DecoderException, ClassNotFoundException {
        //
        if (!byteBuf.isReadable()) {
            return byteBuf;
        }
        
        final int messageSize = byteBuf.readInt();
        final int writerIndex = byteBuf.writerIndex();

        if (messageSize != writerIndex) {
            return byteBuf;
        }

        final int messageSize_type = byteBuf.readInt();

        byte[] data_message_type = new byte[messageSize_type];
        byteBuf.readBytes(data_message_type);

        String message_type = new String(data_message_type);
        Class<?> clazz = classMap.get(message_type);
        if (null == clazz) {
            clazz = Class.forName(message_type);
        }

        byte[] data_message = new byte[byteBuf.readableBytes()];
        byteBuf.readBytes(data_message);

        return ProtostuffUtil.deserialize(data_message, clazz);
    }


}
