package cn.godmao.getty.server.client;

import cn.godmao.getty.common.IConfig;
import cn.godmao.getty.common.codec.IDecoder;
import cn.godmao.getty.common.codec.IEncoder;
import cn.godmao.getty.common.handler.IChannelHandler;
import cn.godmao.getty.common.handler.IDecoderHandler;
import cn.godmao.getty.common.handler.IEncoderHandler;
import cn.godmao.getty.common.handler.IFilterHandler;
import cn.godmao.getty.server.client.base.*;
import cn.godmao.utils.CollectUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelInitializer;
import io.netty.util.concurrent.EventExecutorGroup;

import java.util.*;

public class ClientConfig implements IConfig {
    private String uri;
    private Integer workTheard = 1;
    private String workTheardName = "work";
    private boolean reconnect = true;
    
    //
    private Boolean addIdleHandler = false;
    private Boolean addUnpacker = true;
    private EventExecutorGroup encoderHandlerLoopGroup;
    private EventExecutorGroup decoderHandlerLoopGroup;
    private EventExecutorGroup serviceHandlerLoopGroup;
    private Class<? extends IEncoder<?, ?>> encoderClass = ClientBaseEncoder.class;
    private Class<? extends IDecoder<?, ?>> decoderClass = ClientBaseDecoder.class;
    private Class<? extends ChannelInitializer<Channel>> channelInitializerClass = ClientBaseInitializer.class;
    private Collection<Class<? extends IChannelHandler>> channelHandlerClass = CollectUtil.listOf(ClientBaseHandler.class);
    private Collection<Class<? extends IFilterHandler>> filterHandlerClass = CollectUtil.listOf();
    private Collection<Class<? extends IDecoderHandler>> decoderHandlerClass = CollectUtil.listOf(ClientBaseDecoderHandler.class);
    private Collection<Class<? extends IEncoderHandler>> encoderHandlerClass = CollectUtil.listOf(ClientBaseEncoderHandler.class);
    private Collection<Class<?>> messageClass = new ArrayList<>();

    public ClientConfig(String uri) {
        this.uri = uri;
    }

    private ClientConfig() {
    }


    public String getUri() {
        return uri;
    }

    public Integer getWorkTheard() {
        return workTheard;
    }

    public void setWorkTheard(Integer workTheard) {
        this.workTheard = workTheard;
    }

    public String getWorkTheardName() {
        return workTheardName;
    }

    public void setWorkTheardName(String workTheardName) {
        this.workTheardName = workTheardName;
    }

    @Override
    public Collection<Class<? extends IChannelHandler>> getChannelHandlerClass() {
        return channelHandlerClass;
    }


    @Override
    public Collection<Class<? extends IFilterHandler>> getFilterHandlerClass() {
        return filterHandlerClass;
    }

    @Override
    public Collection<Class<? extends IDecoderHandler>> getDecoderHandlerClass() {
        return decoderHandlerClass;
    }

    @Override
    public Collection<Class<? extends IEncoderHandler>> getEncoderHandlerClass() {
        return encoderHandlerClass;
    }

    @Override
    public Class<? extends ChannelInitializer<Channel>> getChannelInitializerClass() {
        return channelInitializerClass;
    }

    public void setChannelInitializerClass(Class<? extends ChannelInitializer<Channel>> channelInitializerClass) {
        this.channelInitializerClass = channelInitializerClass;
    }

    @Override
    public Boolean getAddIdleHandler() {
        return addIdleHandler;
    }

    public void setAddIdleHandler(Boolean addIdleHandler) {
        this.addIdleHandler = addIdleHandler;
    }

    @Override
    public Class<? extends IEncoder<?, ?>> getEncoderClass() {
        return encoderClass;
    }

    public void setEncoderClass(Class<? extends IEncoder<?, ?>> encoderClass) {
        this.encoderClass = encoderClass;
    }

    @Override
    public Class<? extends IDecoder<?, ?>> getDecoderClass() {
        return decoderClass;
    }

    public void setDecoderClass(Class<? extends IDecoder<?, ?>> decoderClass) {
        this.decoderClass = decoderClass;
    }

    @Override
    public Boolean getAddUnpacker() {
        return addUnpacker;
    }

    public void setAddUnpacker(Boolean addUnpacker) {
        this.addUnpacker = addUnpacker;
    }

    @Override
    public EventExecutorGroup getEncoderHandlerLoopGroup() {
        return encoderHandlerLoopGroup;
    }

    public void setEncoderHandlerLoopGroup(EventExecutorGroup encoderHandlerLoopGroup) {
        this.encoderHandlerLoopGroup = encoderHandlerLoopGroup;
    }

    @Override
    public EventExecutorGroup getDecoderHandlerLoopGroup() {
        return decoderHandlerLoopGroup;
    }

    public void setDecoderHandlerLoopGroup(EventExecutorGroup decoderHandlerLoopGroup) {
        this.decoderHandlerLoopGroup = decoderHandlerLoopGroup;
    }

    @Override
    public EventExecutorGroup getServiceHandlerLoopGroup() {
        return serviceHandlerLoopGroup;
    }

    public void setServiceHandlerLoopGroup(EventExecutorGroup serviceHandlerLoopGroup) {
        this.serviceHandlerLoopGroup = serviceHandlerLoopGroup;
    }

    public boolean isReconnect() {
        return reconnect;
    }

    public void setReconnect(boolean reconnect) {
        this.reconnect = reconnect;
    }

    @Override
    public Collection<Class<?>> getMessageClass() {
        return messageClass;
    }
}
