package cn.godmao.getty.server;

import cn.godmao.getty.common.GettyCommon;
import cn.godmao.getty.common.IConfig;
import cn.godmao.getty.common.IServer;
import cn.godmao.getty.common.handler.IChannelHandler;
import cn.godmao.getty.common.handler.IDecoderHandler;
import cn.godmao.getty.common.handler.IEncoderHandler;
import cn.godmao.getty.common.handler.IFilterHandler;
import cn.godmao.utils.ClassUtil;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.timeout.IdleStateHandler;


public class InitBaseChannel {
    public static void initChannel(ChannelPipeline pipeline, IServer server) {
        IConfig config = server.getConfig();
        int index;

        // 空闲检测器
        index = 0;
        if (server.getConfig().getAddIdleHandler()) {
            pipeline.addLast("event-idle" + ++index, new IdleStateHandler(0, 0, 10 * 60));// 10分钟
        }

        // 拆包器
        index = 0;
        if (server.getConfig().getAddUnpacker()) {
            pipeline.addLast("unpacker" + ++index, new LengthFieldBasedFrameDecoder(1024 * 1024, 0, 4, -4, 0));
        }

        // 解码器
        index = 0;
        for (Class<? extends IDecoderHandler> decoderHandlerClass : config.getDecoderHandlerClass()) {
            IDecoderHandler decoderHandler = ClassUtil.instance(decoderHandlerClass);
            GettyCommon.init(decoderHandler, server, config);
            pipeline.addLast(config.getDecoderHandlerLoopGroup(), "decode-" + ++index, decoderHandler);
        }


        // 编码器
        index = 0;
        for (Class<? extends IEncoderHandler> encoderHandlerClass : config.getEncoderHandlerClass()) {
            IEncoderHandler encoderHandler = ClassUtil.instance(encoderHandlerClass);
            GettyCommon.init(encoderHandler, server, config);
            pipeline.addLast(config.getEncoderHandlerLoopGroup(), "encode-" + ++index, encoderHandler);
        }


        // 过滤器
        index = 0;
        for (Class<? extends IFilterHandler> filterHandlerClass : config.getFilterHandlerClass()) {
            IFilterHandler filterHandler = ClassUtil.instance(filterHandlerClass);
            GettyCommon.init(filterHandler, server, config);
            pipeline.addLast("filter-" + ++index, filterHandler);
        }


        // 业务处理器
        index = 0;
        for (Class<? extends IChannelHandler> handlersClass : config.getChannelHandlerClass()) {
            IChannelHandler channelHandler = ClassUtil.instance(handlersClass);
            GettyCommon.init(channelHandler, server, config);
            pipeline.addLast(config.getServiceHandlerLoopGroup(), "service-" + ++index, channelHandler);
        }
    }
}
