package cn.godmao.getty.common;

import cn.godmao.getty.common.codec.IDecoder;
import cn.godmao.getty.common.codec.IEncoder;
import cn.godmao.getty.common.handler.IChannelHandler;
import cn.godmao.getty.common.handler.IDecoderHandler;
import cn.godmao.getty.common.handler.IEncoderHandler;
import cn.godmao.getty.common.handler.IFilterHandler;
import io.netty.channel.Channel;
import io.netty.channel.ChannelInitializer;
import io.netty.util.concurrent.EventExecutorGroup;

import java.util.Collection;

public interface IConfig {
    Boolean getAddIdleHandler();

    Boolean getAddUnpacker();

    EventExecutorGroup getEncoderHandlerLoopGroup();

    EventExecutorGroup getDecoderHandlerLoopGroup();

    EventExecutorGroup getServiceHandlerLoopGroup();

    Class<? extends IEncoder<?, ?>> getEncoderClass();

    Class<? extends IDecoder<?, ?>> getDecoderClass();

    Class<? extends ChannelInitializer<? extends Channel>> getChannelInitializerClass();

    Collection<Class<?>> getMessageClass();

    Collection<Class<? extends IFilterHandler>> getFilterHandlerClass();

    Collection<Class<? extends IDecoderHandler>> getDecoderHandlerClass();

    Collection<Class<? extends IEncoderHandler>> getEncoderHandlerClass();

    Collection<Class<? extends IChannelHandler>> getChannelHandlerClass();
}
