package cn.godmao.getty.common;

import cn.godmao.common.IRunnable;
import cn.godmao.common.ISchedule;
import cn.godmao.executor.AbstractExecutorService;
import io.netty.util.NettyRuntime;
import io.netty.util.concurrent.*;

import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;

public class ExecutorService extends AbstractExecutorService<EventExecutor> implements ISchedule {

    public ExecutorService(int threads, ThreadFactory threadFactory) {
        super(new EventExecutor[threads]);
        setThreadFactory(threadFactory);
    }

    public ExecutorService() {
        this(NettyRuntime.availableProcessors(), null);
    }

    public ExecutorService(int threads) {
        this(threads, null);
    }


    private void setThreadFactory(ThreadFactory threadFactory) {
        ThreadFactory factory = null == threadFactory ? new DefaultThreadFactory(this.getClass(), false) : threadFactory;
        for (int i = 0; i < getExecutors().length; i++) {
            getExecutors()[i] = new DefaultEventExecutor(factory);
        }
    }

    //
    public ScheduledFuture<?> schedule(Object key, IRunnable runnable, long delay) {
        return schedule(select(key), runnable, delay);
    }

    public ScheduledFuture<?> schedule(Object key, IRunnable runnable, long delay, long period) {
        return schedule(select(key), runnable, delay, period);
    }

    @Override
    public ScheduledFuture<?> schedule(IRunnable runnable, long delay) {
        return schedule(next(), runnable, delay);
    }

    @Override
    public ScheduledFuture<?> schedule(IRunnable runnable, long delay, long period) {
        return schedule(next(), runnable, delay, period);
    }

    //
    @Override
    public Future<?> submit(Object key, IRunnable task) {
        return submit(select(key), task);
    }

    @Override
    public <T> Future<T> submit(Object key, IRunnable task, T result) {
        return submit(select(key), task, result);
    }

    @Override
    public <T> Future<T> submit(Object key, Callable<T> task) {
        return submit(select(key), task);
    }

    @Override
    public Future<?> submit(EventExecutor executor, IRunnable task) {
        return executor.submit(task);
    }

    @Override
    public <T> Future<T> submit(EventExecutor executor, IRunnable task, T result) {
        return executor.submit(task, result);
    }

    @Override
    public <T> Future<T> submit(EventExecutor executor, Callable<T> task) {
        return executor.submit(task);
    }

    @Override
    public Future<?> submit(IRunnable task) {
        return submit(next(), task);
    }

    @Override
    public <T> Future<T> submit(IRunnable task, T result) {
        return submit(next(), task, result);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return submit(next(), task);
    }
}
