package cn.godmao.getty.common;

import cn.godmao.getty.common.channel.IChannel;
import io.netty.channel.Channel;
import io.netty.util.concurrent.EventExecutor;

public abstract class AbstractChannel<I> implements IChannel<I> {
    private final Channel channel;
    private I id;
    private EventExecutor executor;
    private boolean authorization;

    public AbstractChannel(I id, Channel channel, EventExecutor executor) {
        this.id = id;
        this.channel = channel;
        this.executor = executor;
    }

    @Override
    public I getId() {
        return id;
    }

    @Override
    public Channel getChannel() {
        return channel;
    }

    @Override
    public EventExecutor getExecutor() {
        return executor;
    }

    @Override
    public void setId(I id) {
        this.id = id;
    }

    @Override
    public void setExecutor(EventExecutor executor) {
        this.executor = executor;
    }

    @Override
    public void setAuthorization(boolean authorization) {
        this.authorization = authorization;
    }

    @Override
    public boolean isAuthorization() {
        return authorization;
    }

}
