/*
 * Decompiled with CFR 0.152.
 */
package cn.godmao.getty.server.base;

import cn.godmao.common.Init;
import cn.godmao.getty.InitBaseChannel;
import cn.godmao.getty.channel.IChannel;
import cn.godmao.getty.server.AbstractServer;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolConfig;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.handler.codec.http.websocketx.extensions.compression.WebSocketServerCompressionHandler;
import io.netty.handler.stream.ChunkedWriteHandler;

public class WebsocketServerBaseInitializer
extends ChannelInitializer<Channel>
implements Init.Init1<AbstractServer<IChannel<?>>> {
    private AbstractServer<IChannel<?>> server;

    public void init(AbstractServer<IChannel<?>> server) {
        this.server = server;
    }

    protected void initChannel(Channel ch) {
        ChannelPipeline pipeline = ch.pipeline();
        pipeline.addLast(new ChannelHandler[]{new HttpServerCodec()});
        pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(65536)});
        pipeline.addLast(new ChannelHandler[]{new ChunkedWriteHandler()});
        pipeline.addLast(new ChannelHandler[]{new WebSocketServerCompressionHandler()});
        pipeline.addLast(new ChannelHandler[]{new WebSocketServerProtocolHandler(WebSocketServerProtocolConfig.newBuilder().websocketPath(this.server.getConfig().getPath()).maxFramePayloadLength(0x100000).checkStartsWith(true).allowExtensions(true).build())});
        InitBaseChannel.initChannel(pipeline, this.server);
    }
}

