/*
 * Decompiled with CFR 0.152.
 */
package cn.godmao.getty.server;

import cn.godmao.common.Init;
import cn.godmao.getty.GettyCommon;
import cn.godmao.getty.IServer;
import cn.godmao.getty.channel.IChannel;
import cn.godmao.getty.channel.IChannelService;
import cn.godmao.getty.codec.IDecoder;
import cn.godmao.getty.codec.IEncoder;
import cn.godmao.getty.server.ServerConfig;
import cn.godmao.utils.ClassUtil;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServer<C extends IChannel<?>>
implements IServer,
Init.Init0 {
    public final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ServerConfig config;
    private IEncoder<?, ?> encoder;
    private IDecoder<?, ?> decoder;
    private IChannelService<?, C> channelService;
    private ChannelInitializer<Channel> channelInitializer;
    private ServerBootstrap bootstrap;
    private EventLoopGroup bossGroup;
    private EventLoopGroup childGroup;
    private ChannelFuture channelFuture;

    public AbstractServer(ServerConfig serverConfig) {
        this.config = serverConfig;
    }

    public AbstractServer() {
        this(new ServerConfig());
    }

    public AbstractServer(Integer port) {
        this(new ServerConfig(port));
    }

    public AbstractServer(Integer port, String path) {
        this(new ServerConfig(port, path));
    }

    public void init() throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        this.channelInitializer = (ChannelInitializer)ClassUtil.instance(this.config.getChannelInitializerClass());
        this.channelService = (IChannelService)ClassUtil.instance(this.config.getChannelServiceClass());
        this.encoder = (IEncoder)ClassUtil.instance(this.config.getEncoderClass());
        this.decoder = (IDecoder)ClassUtil.instance(this.config.getDecoderClass());
        GettyCommon.init(this.channelInitializer, this, this.config);
        GettyCommon.init(this.channelService, this, this.config);
        GettyCommon.init(this.encoder, this, this.config);
        GettyCommon.init(this.decoder, this, this.config);
    }

    @Override
    public void start() throws Exception {
        this.init();
        boolean epoll = GettyCommon.isEpoll();
        this.log.info("port: {}", (Object)this.config.getPort());
        Integer workTheards = this.config.getWorkTheard();
        String workTheardName = this.config.getWorkTheardName();
        DefaultThreadFactory threadFactory = new DefaultThreadFactory(workTheardName);
        this.bossGroup = epoll ? new EpollEventLoopGroup(1) : new NioEventLoopGroup(1);
        this.childGroup = epoll ? new EpollEventLoopGroup(workTheards.intValue(), (ThreadFactory)threadFactory) : new NioEventLoopGroup(workTheards.intValue(), (ThreadFactory)threadFactory);
        this.bootstrap = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)this.bootstrap.group(this.bossGroup, this.childGroup).channel(epoll ? EpollServerSocketChannel.class : NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)1024)).option(ChannelOption.SO_REUSEADDR, (Object)true)).childOption(ChannelOption.SO_SNDBUF, (Object)65535).childOption(ChannelOption.SO_RCVBUF, (Object)65535).childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT).childHandler(this.channelInitializer);
        this.bind();
    }

    private void bind() {
        try {
            this.channelFuture = this.bootstrap.bind(this.config.getPort().intValue()).sync();
            this.channelFuture.channel().closeFuture().sync();
        }
        catch (Exception e) {
            this.log.error("Server start error!", (Throwable)e);
            System.exit(0);
        }
        finally {
            this.childGroup.shutdownGracefully();
            this.bossGroup.shutdownGracefully();
        }
    }

    @Override
    public void stop() {
        if (this.channelFuture != null) {
            GettyCommon.close(this.channelFuture.channel());
        }
        int quietPeriod = 5;
        int timeout = 30;
        TimeUnit timeUnit = TimeUnit.SECONDS;
        if (null != this.childGroup) {
            this.childGroup.shutdownGracefully(5L, 30L, timeUnit);
        }
        if (null != this.bossGroup) {
            this.bossGroup.shutdownGracefully(5L, 30L, timeUnit);
        }
    }

    @Override
    public ServerConfig getConfig() {
        return this.config;
    }

    public IChannelService<?, C> getChannelService() {
        return this.channelService;
    }

    public <EP, ER> IEncoder<EP, ER> getEncoder() {
        return this.encoder;
    }

    public <DP, DR> IDecoder<DP, DR> getDecoder() {
        return this.decoder;
    }

    public abstract void onOpen(C var1);

    public abstract void onClose(C var1);

    public abstract void onError(C var1, Throwable var2);

    public abstract void onMessage(C var1, Object var2);
}

