/*
 * Decompiled with CFR 0.152.
 */
package cn.godmao.getty.client;

import cn.godmao.common.Init;
import cn.godmao.getty.GettyCommon;
import cn.godmao.getty.IServer;
import cn.godmao.getty.client.ClientConfig;
import cn.godmao.getty.codec.IDecoder;
import cn.godmao.getty.codec.IEncoder;
import cn.godmao.utils.ClassUtil;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.GenericFutureListener;
import java.lang.reflect.InvocationTargetException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClient
implements IServer,
Init.Init0 {
    public final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ClientConfig config;
    private final URI uri;
    private IEncoder<?, ?> encoder;
    private IDecoder<?, ?> decoder;
    private ChannelInitializer<Channel> channelInitializer;
    private Bootstrap bootstrap;
    private EventLoopGroup group;
    private ChannelFuture channelFuture;
    private Channel channel;

    public AbstractClient(String uri) {
        this.uri = URI.create(uri);
        this.config = new ClientConfig(uri);
    }

    public void init() throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        this.channelInitializer = (ChannelInitializer)ClassUtil.instance(this.config.getChannelInitializerClass());
        this.encoder = (IEncoder)ClassUtil.instance(this.config.getEncoderClass());
        this.decoder = (IDecoder)ClassUtil.instance(this.config.getDecoderClass());
        GettyCommon.init(this.channelInitializer, this, this.config);
        GettyCommon.init(this.encoder, this, this.config);
        GettyCommon.init(this.decoder, this, this.config);
    }

    @Override
    public ClientConfig getConfig() {
        return this.config;
    }

    public <EP, ER> IEncoder<EP, ER> getEncoder() {
        return this.encoder;
    }

    public <DP, DR> IDecoder<DP, DR> getDecoder() {
        return this.decoder;
    }

    public URI getUri() {
        return this.uri;
    }

    @Override
    public void start() throws Exception {
        this.init();
        boolean epoll = GettyCommon.isEpoll();
        this.log.info("uri: {}", (Object)this.config.getUri());
        Integer workTheards = this.config.getWorkTheard();
        String workTheardName = this.config.getWorkTheardName();
        DefaultThreadFactory threadFactory = new DefaultThreadFactory(workTheardName);
        this.group = epoll ? new EpollEventLoopGroup(workTheards.intValue(), (ThreadFactory)threadFactory) : new NioEventLoopGroup(workTheards.intValue(), (ThreadFactory)threadFactory);
        this.bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)this.bootstrap.group(this.group)).channel(epoll ? EpollSocketChannel.class : NioSocketChannel.class)).remoteAddress((SocketAddress)new InetSocketAddress(this.uri.getHost(), this.uri.getPort() == -1 ? 443 : this.uri.getPort())).option(ChannelOption.SO_KEEPALIVE, (Object)true)).handler(this.channelInitializer);
        this.connect();
    }

    public void connect() {
        this.channelFuture = this.bootstrap.connect();
        this.channel = this.channelFuture.channel();
        this.channelFuture.addListener((GenericFutureListener)((ChannelFutureListener)channelFuture -> {
            this.log.debug("connect: {} status: {}", (Object)this.config.getUri(), (Object)channelFuture.isSuccess());
            if (!channelFuture.isSuccess()) {
                channelFuture.channel().eventLoop().schedule(this::connect, 3L, TimeUnit.SECONDS);
            }
        }));
    }

    @Override
    public void stop() {
        if (null != this.channelFuture) {
            GettyCommon.close(this.channelFuture.channel());
        }
        int quietPeriod = 5;
        int timeout = 30;
        TimeUnit timeUnit = TimeUnit.SECONDS;
        if (null != this.group) {
            this.group.shutdownGracefully(5L, 30L, timeUnit);
        }
    }

    public boolean isOnline() {
        return null != this.channel && this.channel.isActive();
    }

    public String getChannelId() {
        return null == this.channel ? null : this.channel.id().asLongText();
    }

    public void send(Object message) {
        GettyCommon.send(this.channel, message);
    }

    public abstract void onOpen();

    public abstract void onClose();

    public abstract void onError(Throwable var1);

    public abstract void onMessage(Object var1);
}

