/*
 * Decompiled with CFR 0.152.
 */
package cn.godmao.getty.channel;

import cn.godmao.common.IExecute;
import cn.godmao.common.IRunnable;
import cn.godmao.getty.GettyCommon;
import io.netty.channel.Channel;
import io.netty.util.concurrent.DefaultEventExecutor;
import io.netty.util.concurrent.EventExecutor;
import java.util.concurrent.Executor;

public interface IChannel<I>
extends IExecute<EventExecutor> {
    public I getId();

    public void setId(I var1);

    public Channel getChannel();

    public EventExecutor getExecutor();

    public void setExecutor(EventExecutor var1);

    public boolean isAuthorization();

    public void setAuthorization(boolean var1);

    default public void login(I id, EventExecutor executor) {
        this.execute(() -> {
            this.setId(id);
            this.setExecutor(executor);
            this.setAuthorization(true);
        });
    }

    default public void logout() {
        this.execute(() -> this.setAuthorization(false));
    }

    default public void closeChannel() {
        this.execute(() -> {
            if (this.isOnline()) {
                GettyCommon.close(this.getChannel());
            }
        });
    }

    default public boolean isOnline() {
        return null != this.getChannel() && this.getChannel().isActive();
    }

    default public void send(Object message) {
        this.execute(() -> GettyCommon.send(this.getChannel(), message));
    }

    default public void execute(IRunnable runnable) {
        this.execute((Executor)this.getExecutor(), runnable);
    }

    default public void lazyExecute(EventExecutor executor, IRunnable runnable) {
        if (null == executor) {
            this.run((Runnable)runnable);
        } else if (executor instanceof DefaultEventExecutor) {
            ((DefaultEventExecutor)executor).lazyExecute(() -> this.run((Runnable)runnable));
        } else {
            executor.execute(() -> this.run((Runnable)runnable));
        }
    }
}

