/*
 * Decompiled with CFR 0.152.
 */
package cn.godmao.getty;

import cn.godmao.common.Init;
import cn.godmao.getty.AbstractChannel;
import cn.godmao.getty.ExecutorService;
import cn.godmao.getty.GettyCommon;
import cn.godmao.getty.channel.IChannelService;
import cn.godmao.getty.server.AbstractServer;
import cn.godmao.utils.ClassUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.PlatformDependent;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ThreadFactory;

public abstract class AbstractChannelService<C extends AbstractChannel>
implements IChannelService<Object, C>,
Init.Init1<AbstractServer<C>> {
    private final ConcurrentMap<String, C> channelGroup = PlatformDependent.newConcurrentHashMap();
    private final ChannelFutureListener remover = future -> this.remove(future.channel());
    private final Class<C> channelClass = ClassUtil.find0((Object)this, AbstractChannelService.class, (String)"C");
    private ExecutorService executorService;
    private AbstractServer<?> server;

    public ConcurrentMap<String, C> getChannelGroup() {
        return this.channelGroup;
    }

    public Class<C> getChannelClass() {
        return this.channelClass;
    }

    public synchronized void init(AbstractServer<C> abstractServer) {
        this.server = abstractServer;
        this.executorService = new ExecutorService(abstractServer.getConfig().getUserTheard(), (ThreadFactory)new DefaultThreadFactory(abstractServer.getConfig().getUserTheardName()));
    }

    public AbstractServer<?> getServer() {
        return this.server;
    }

    @Override
    public Collection<C> get() {
        return this.channelGroup.values();
    }

    @Override
    public C get(Object o) {
        AbstractChannel serverChannel;
        Channel channel = null;
        String key = null;
        if (o instanceof Channel) {
            channel = (Channel)o;
        } else if (o instanceof ChannelHandlerContext) {
            channel = ((ChannelHandlerContext)o).channel();
        } else if (o instanceof String) {
            key = (String)o;
        } else {
            throw new IllegalArgumentException("\u672a\u77e5\u7c7b\u578b: " + o);
        }
        if (null != channel) {
            key = this.getKey(channel);
        }
        if (null == (serverChannel = (AbstractChannel)this.getChannelGroup().get(key))) {
            serverChannel = (AbstractChannel)ClassUtil.instance(this.getChannelClass());
            serverChannel.init((Object)key, channel, (EventExecutor)this.getExecutorService().next());
            this.add(serverChannel);
        }
        return (C)serverChannel;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void send(Set<?> ids, Object message) {
        Object data = this.server.getEncoder().encode(message);
        boolean emptyIds = null == ids;
        for (AbstractChannel channelUser : this.get()) {
            if (!emptyIds && !ids.contains(channelUser.getId())) continue;
            channelUser.send(GettyCommon.safeDuplicate(data));
        }
        ReferenceCountUtil.release(data);
    }

    public void send(Object message) {
        this.send(null, message);
    }

    protected String getKey(Channel channel) {
        return channel.id().asLongText();
    }

    protected void add(C channelUser) {
        boolean added;
        boolean bl = added = this.channelGroup.putIfAbsent(this.getKey(((AbstractChannel)channelUser).getChannel()), channelUser) == null;
        if (added) {
            ((AbstractChannel)channelUser).getChannel().closeFuture().addListener((GenericFutureListener)this.remover);
        }
    }

    private void remove(Channel channel) {
        AbstractChannel channelUser = (AbstractChannel)this.channelGroup.remove(this.getKey(channel));
        if (channelUser != null) {
            channelUser.getChannel().closeFuture().removeListener((GenericFutureListener)this.remover);
        }
    }
}

