package cn.godmao.getty.server.base;

import cn.godmao.common.Init;
import cn.godmao.getty.InitBaseChannel;
import cn.godmao.getty.channel.IChannel;
import cn.godmao.getty.server.AbstractServer;
import io.netty.channel.Channel;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolConfig;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.handler.codec.http.websocketx.extensions.compression.WebSocketServerCompressionHandler;
import io.netty.handler.stream.ChunkedWriteHandler;

public class WebsocketServerBaseInitializer extends ChannelInitializer<Channel> implements Init.Init1<AbstractServer<IChannel<?>>> {

    private AbstractServer<IChannel<?>> server;

    @Override
    public void init(AbstractServer<IChannel<?>> server) {
        this.server = server;
    }

    @Override
    protected void initChannel(Channel ch) {
        ChannelPipeline pipeline = ch.pipeline();

        // websocket
        pipeline.addLast(new HttpServerCodec());
        pipeline.addLast(new HttpObjectAggregator(65536));
        pipeline.addLast(new ChunkedWriteHandler());
        pipeline.addLast(new WebSocketServerCompressionHandler());
        pipeline.addLast(new WebSocketServerProtocolHandler(WebSocketServerProtocolConfig.newBuilder()
                // 验证 URL
                .websocketPath(server.getConfig().getPath())
                // 默认数据包大小
                .maxFramePayloadLength(1024 * 1024)
                .checkStartsWith(true)
                // 开启 WebSocket 扩展
                .allowExtensions(true).build()));

        //
        InitBaseChannel.initChannel(pipeline, server);
    }


}
