package cn.godmao.getty.server.base;

import cn.godmao.common.Init;
import cn.godmao.getty.codec.IEncoder;
import cn.godmao.getty.server.ServerConfig;
import cn.godmao.utils.CollectUtil;
import cn.godmao.utils.ProtostuffUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.EncoderException;

import java.util.Map;

public class ServerBaseEncoder implements IEncoder<Object, ByteBuf>, Init.Init1<ServerConfig> {
    Map<String, ? extends Class<?>> classMap;


    @Override
    public void init(ServerConfig config) {
        this.classMap = CollectUtil.toMap(config.getMessageClass(), Class::getSimpleName);
    }

    @Override
    public ByteBuf encode(Object message) throws EncoderException {
        if (null == message) {
            return null;
        }
        ByteBuf byteBuf = null;
        if (message instanceof ByteBuf) {
            ByteBuf byteBuf_ = (ByteBuf) message;
            byteBuf = byteBuf_.retainedDuplicate();
        } else if (message instanceof byte[]) {
            byte[] bytes = (byte[]) message;
            byteBuf = Unpooled.wrappedBuffer(bytes);
        } else {
            final Class<?> messageClass = message.getClass();
            final String message_simpleName = messageClass.getSimpleName();
            String message_type = null;
            if (classMap.containsKey(message_simpleName)) {
                message_type = message_simpleName;
            } else {
                message_type = messageClass.getName();
            }
            byte[] bytes_message_type = message_type.getBytes();
            byte[] bytes_message = ProtostuffUtil.serialize(message);
            final int size = 8 + bytes_message.length + bytes_message_type.length;
            byteBuf = ByteBufAllocator.DEFAULT.directBuffer(size);
            byteBuf.writeInt(size);
            byteBuf.writeInt(bytes_message_type.length);
            byteBuf.writeBytes(bytes_message_type);
            byteBuf.writeBytes(bytes_message);
        }

        return byteBuf;
    }


}