package cn.godmao.getty.client.base;

import cn.godmao.common.Init;
import cn.godmao.getty.handler.IEncoderHandler;
import cn.godmao.getty.client.AbstractClient;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;

import java.util.List;

public class WebsocketClientBaseEncoderHandler extends MessageToMessageEncoder<TextWebSocketFrame> implements IEncoderHandler, Init.Init1<AbstractClient> {
    private AbstractClient server;

    @Override
    public void init(AbstractClient server) {
        this.server = server;
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, TextWebSocketFrame msg, List<Object> out) throws Exception {
        Object obj = server.getEncoder().encode(msg);
        if (null != obj) {
            out.add(obj);
        }
    }
}
