package cn.godmao.getty.client.base;

import cn.godmao.common.Init;
import cn.godmao.getty.handler.IDecoderHandler;
import cn.godmao.getty.client.AbstractClient;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;

import java.util.List;

public class WebsocketClientBaseDecoderHandler extends MessageToMessageDecoder<TextWebSocketFrame> implements IDecoderHandler, Init.Init1<AbstractClient> {
    private AbstractClient server;

    @Override
    public void init(AbstractClient server) {
        this.server = server;
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, TextWebSocketFrame msg, List<Object> out) throws Exception {
        Object data = server.getDecoder().decode(msg);
        if (null == data) {
            return;
        }
        out.add(data);
    }
}
