package cn.godmao.getty.channel;
import cn.godmao.getty.ExecutorService;
import java.util.Collection;


public interface IChannelService<I, C extends IChannel<I>> {
    Collection<? extends C> get();

    C get(Object o) throws Exception;

    ExecutorService getExecutorService();

    default void bind(I id, C channelUser) {
        channelUser.login(id, getExecutorService().select(id));
    }

    default void unbind(C channelUser) {
        channelUser.logout();
        channelUser.closeChannel();
    }
}
