package cn.godmao.getty.channel;

import cn.godmao.common.IExecute;
import cn.godmao.common.IRunnable;
import cn.godmao.getty.GettyCommon;
import io.netty.channel.Channel;
import io.netty.util.concurrent.DefaultEventExecutor;
import io.netty.util.concurrent.EventExecutor;

public interface IChannel<I> extends IExecute<EventExecutor> {
    I getId();

    void setId(I id);

    Channel getChannel();

    EventExecutor getExecutor();

    void setExecutor(EventExecutor executor);

    boolean isAuthorization();

    void setAuthorization(boolean authorization);

    default void login(I id, EventExecutor executor) {
        execute(() -> {
            setId(id);
            setExecutor(executor);
            setAuthorization(true);
        });
    }

    default void logout() {
        execute(() -> {
            setAuthorization(false);
        });
    }

    default void closeChannel() {
        execute(() -> {
            if (isOnline()) {
                GettyCommon.close(getChannel());
            }
        });
    }

    default boolean isOnline() {
        return null != getChannel() && getChannel().isActive();
    }

    default void send(Object message) {
        execute(() -> GettyCommon.send(getChannel(), message));
    }

    @Override
    default void execute(IRunnable runnable) {
        execute(getExecutor(), runnable);
    }

    default void lazyExecute(EventExecutor executor, IRunnable runnable) {
        if (null == executor) {
            run(runnable);
        } else if (executor instanceof DefaultEventExecutor) {
            ((DefaultEventExecutor) executor).lazyExecute(() -> run(runnable));
        } else {
            executor.execute(() -> run(runnable));
        }
    }
}
