package cn.godmao.getty;

import cn.godmao.getty.codec.IDecoder;
import cn.godmao.getty.codec.IEncoder;
import cn.godmao.getty.handler.IChannelHandler;
import cn.godmao.getty.handler.IDecoderHandler;
import cn.godmao.getty.handler.IEncoderHandler;
import cn.godmao.getty.handler.IFilterHandler;
import io.netty.channel.Channel;
import io.netty.channel.ChannelInitializer;
import io.netty.util.concurrent.EventExecutorGroup;

import java.util.Collection;

public interface IConfig {
    Boolean getAddIdleHandler();

    Boolean getAddUnpacker();

    EventExecutorGroup getEncoderHandlerLoopGroup();

    EventExecutorGroup getDecoderHandlerLoopGroup();

    EventExecutorGroup getServiceHandlerLoopGroup();

    Class<? extends IEncoder<?, ?>> getEncoderClass();

    Class<? extends IDecoder<?, ?>> getDecoderClass();

    Class<? extends ChannelInitializer<? extends Channel>> getChannelInitializerClass();

    Collection<Class<?>> getMessageClass();

    Collection<Class<? extends IFilterHandler>> getFilterHandlerClass();

    Collection<Class<? extends IDecoderHandler>> getDecoderHandlerClass();

    Collection<Class<? extends IEncoderHandler>> getEncoderHandlerClass();

    Collection<Class<? extends IChannelHandler>> getChannelHandlerClass();
}
