/*
 * Decompiled with CFR 0.152.
 */
package cn.godmao.getty.server_websocket.client;

import cn.godmao.common.Init;
import cn.godmao.getty.server.InitBaseChannel;
import cn.godmao.getty.server_websocket.client.AbstractWebsocketClient;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.WebSocketClientProtocolConfig;
import io.netty.handler.codec.http.websocketx.WebSocketClientProtocolHandler;
import io.netty.handler.codec.http.websocketx.extensions.compression.WebSocketClientCompressionHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.handler.stream.ChunkedWriteHandler;

public class WebsocketClientInitializer
extends ChannelInitializer<Channel>
implements Init.Init1<AbstractWebsocketClient> {
    private AbstractWebsocketClient server;

    public void init(AbstractWebsocketClient server) {
        this.server = server;
    }

    protected void initChannel(Channel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        if (this.server.getPort().equals(443)) {
            SslContext sslCtx = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build();
            pipeline.addLast(new ChannelHandler[]{sslCtx.newHandler(ch.alloc(), this.server.getHost(), this.server.getPort().intValue())});
        }
        pipeline.addLast(new ChannelHandler[]{new HttpClientCodec()});
        pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(65536)});
        pipeline.addLast(new ChannelHandler[]{new ChunkedWriteHandler()});
        pipeline.addLast(new ChannelHandler[]{WebSocketClientCompressionHandler.INSTANCE});
        pipeline.addLast(new ChannelHandler[]{new WebSocketClientProtocolHandler(WebSocketClientProtocolConfig.newBuilder().webSocketUri(this.server.getUri()).allowExtensions(true).maxFramePayloadLength(Integer.MAX_VALUE).build())});
        InitBaseChannel.initChannel(pipeline, this.server);
    }
}

