/*
 * Decompiled with CFR 0.152.
 */
package cn.godmao.getty.server_websocket.client;

import cn.godmao.common.Init;
import cn.godmao.getty.common.GettyCommon;
import cn.godmao.getty.common.IServer;
import cn.godmao.getty.common.codec.IDecoder;
import cn.godmao.getty.common.codec.IEncoder;
import cn.godmao.getty.server_websocket.client.WebsocketClientConfig;
import cn.godmao.utils.ClassUtil;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWebsocketClient
implements IServer,
Init.Init0 {
    public final Logger log = LoggerFactory.getLogger(this.getClass());
    private final WebsocketClientConfig config;
    private final IEncoder<?, ?> encoder;
    private final IDecoder<?, ?> decoder;
    private final ChannelInitializer<Channel> channelInitializer;
    private Bootstrap bootstrap;
    private EventLoopGroup group;
    private ChannelFuture channelFuture;
    private Channel channel;

    public AbstractWebsocketClient(String uri) {
        this.config = new WebsocketClientConfig(uri);
        this.channelInitializer = (ChannelInitializer)ClassUtil.instance(this.config.getChannelInitializerClass());
        this.encoder = (IEncoder)ClassUtil.instance(this.config.getEncoderClass());
        this.decoder = (IDecoder)ClassUtil.instance(this.config.getDecoderClass());
    }

    public void init() throws Exception {
        GettyCommon.init(this.channelInitializer, this, this.config);
        GettyCommon.init(this.encoder, this, this.config);
        GettyCommon.init(this.decoder, this, this.config);
    }

    public String getHost() {
        return this.config.getHost();
    }

    public Integer getPort() {
        return this.config.getPort();
    }

    public String getUri() {
        return this.config.getUri();
    }

    @Override
    public WebsocketClientConfig getConfig() {
        return this.config;
    }

    public <EP, ER> IEncoder<EP, ER> getEncoder() {
        return this.encoder;
    }

    public <DP, DR> IDecoder<DP, DR> getDecoder() {
        return this.decoder;
    }

    @Override
    public void start() throws Exception {
        this.init();
        boolean epoll = GettyCommon.isEpoll();
        this.log.info("uri: {}", (Object)this.getUri());
        this.log.info("host: {}", (Object)this.getHost());
        this.log.info("port: {}", (Object)this.getPort());
        Integer workTheards = this.config.getWorkTheard();
        String workTheardName = this.config.getWorkTheardName();
        DefaultThreadFactory threadFactory = new DefaultThreadFactory(workTheardName);
        this.group = epoll ? new EpollEventLoopGroup(workTheards.intValue(), (ThreadFactory)threadFactory) : new NioEventLoopGroup(workTheards.intValue(), (ThreadFactory)threadFactory);
        this.bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)this.bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)true)).option(ChannelOption.TCP_NODELAY, (Object)true)).group(this.group)).channel(epoll ? EpollSocketChannel.class : NioSocketChannel.class)).handler(this.channelInitializer)).remoteAddress((SocketAddress)new InetSocketAddress(this.config.getHost(), (int)this.config.getPort()));
        this.connect();
    }

    public void connect() throws InterruptedException {
        this.channelFuture = this.bootstrap.connect();
        this.channel = this.channelFuture.channel();
        this.channelFuture.addListener((GenericFutureListener)((ChannelFutureListener)channelFuture -> {
            this.log.debug("connect: {} status: {}", (Object)this.config.getUri(), (Object)channelFuture.isSuccess());
            if (channelFuture.isSuccess()) {
                return;
            }
            channelFuture.channel().eventLoop().schedule(() -> {
                try {
                    this.connect();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }, 3L, TimeUnit.SECONDS);
        }));
        this.channelFuture.channel().closeFuture().sync();
    }

    @Override
    public void stop() {
        if (null != this.channelFuture) {
            GettyCommon.close(this.channelFuture.channel());
        }
        int quietPeriod = 5;
        int timeout = 30;
        TimeUnit timeUnit = TimeUnit.SECONDS;
        if (null != this.group) {
            this.group.shutdownGracefully(5L, 30L, timeUnit);
        }
    }

    public Channel getChannel() {
        return this.channel;
    }

    public boolean isOnline() {
        return null != this.channel && this.channel.isActive();
    }

    public String getChannelId() {
        return null == this.channel ? null : this.channel.id().asLongText();
    }

    public void send(Object message) {
        GettyCommon.send(this.channel, message);
    }

    public abstract void onOpen();

    public abstract void onClose();

    public abstract void onError(Throwable var1);

    public abstract void onMessage(Object var1);
}

