/*
 * Decompiled with CFR 0.152.
 */
package cn.godmao.getty.server.client.base;

import cn.godmao.common.Init;
import cn.godmao.getty.common.GettyCommon;
import cn.godmao.getty.common.handler.IChannelHandler;
import cn.godmao.getty.server.client.AbstractClient;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.timeout.IdleStateEvent;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientBaseHandler
extends ChannelInboundHandlerAdapter
implements IChannelHandler,
Init.Init1<AbstractClient> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private AbstractClient abstractClient;

    public void init(AbstractClient abstractClient) {
        this.abstractClient = abstractClient;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.abstractClient.onError(cause);
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        this.abstractClient.onClose();
        if (this.abstractClient.getConfig().isReconnect()) {
            this.abstractClient.connect();
        }
    }

    public void channelActive(ChannelHandlerContext ctx) {
        this.abstractClient.onOpen();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        this.abstractClient.onMessage(msg);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        if (IdleStateEvent.FIRST_ALL_IDLE_STATE_EVENT.equals(evt)) {
            this.log.debug("FIRST_ALL_IDLE_STATE_EVENT {}", evt);
            GettyCommon.close(ctx.channel());
        } else if (IdleStateEvent.WRITER_IDLE_STATE_EVENT.equals(evt)) {
            this.log.debug("WRITER_IDLE_STATE_EVENT {} {}", (Object)LocalDateTime.now(), evt);
        } else if (IdleStateEvent.ALL_IDLE_STATE_EVENT.equals(evt)) {
            this.log.debug("ALL_IDLE_STATE_EVENT {}", evt);
        } else if (IdleStateEvent.FIRST_READER_IDLE_STATE_EVENT.equals(evt)) {
            this.log.debug("FIRST_READER_IDLE_STATE_EVENT {}", evt);
        } else if (IdleStateEvent.FIRST_WRITER_IDLE_STATE_EVENT.equals(evt)) {
            this.log.debug("FIRST_WRITER_IDLE_STATE_EVENT {}", evt);
        } else if (IdleStateEvent.READER_IDLE_STATE_EVENT.equals(evt)) {
            this.log.debug("READER_IDLE_STATE_EVENT {}", evt);
        } else {
            this.log.debug("IDLE_STATE_EVENT {}", evt);
        }
    }
}

