/*
 * Decompiled with CFR 0.152.
 */
package cn.godmao.getty.server;

import cn.godmao.getty.common.GettyCommon;
import cn.godmao.getty.common.IConfig;
import cn.godmao.getty.common.IServer;
import cn.godmao.getty.common.handler.IChannelHandler;
import cn.godmao.getty.common.handler.IDecoderHandler;
import cn.godmao.getty.common.handler.IEncoderHandler;
import cn.godmao.getty.common.handler.IFilterHandler;
import cn.godmao.utils.ClassUtil;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.timeout.IdleStateHandler;

public class InitBaseChannel {
    public static void initChannel(ChannelPipeline pipeline, IServer server) {
        IConfig config = server.getConfig();
        int index = 0;
        if (server.getConfig().getAddIdleHandler().booleanValue()) {
            pipeline.addLast("event-idle" + ++index, (ChannelHandler)new IdleStateHandler(0, 0, 600));
        }
        index = 0;
        if (server.getConfig().getAddUnpacker().booleanValue()) {
            pipeline.addLast("unpacker" + ++index, (ChannelHandler)new LengthFieldBasedFrameDecoder(0x100000, 0, 4, -4, 0));
        }
        index = 0;
        for (Class<? extends IDecoderHandler> clazz : config.getDecoderHandlerClass()) {
            IDecoderHandler decoderHandler = (IDecoderHandler)ClassUtil.instance(clazz);
            GettyCommon.init(decoderHandler, server, config);
            pipeline.addLast(config.getDecoderHandlerLoopGroup(), "decode-" + ++index, (ChannelHandler)decoderHandler);
        }
        index = 0;
        for (Class<IChannelHandler> clazz : config.getEncoderHandlerClass()) {
            IEncoderHandler encoderHandler = (IEncoderHandler)ClassUtil.instance(clazz);
            GettyCommon.init(encoderHandler, server, config);
            pipeline.addLast(config.getEncoderHandlerLoopGroup(), "encode-" + ++index, (ChannelHandler)encoderHandler);
        }
        index = 0;
        for (Class<IChannelHandler> clazz : config.getFilterHandlerClass()) {
            IFilterHandler filterHandler = (IFilterHandler)ClassUtil.instance(clazz);
            GettyCommon.init(filterHandler, server, config);
            pipeline.addLast("filter-" + ++index, (ChannelHandler)filterHandler);
        }
        index = 0;
        for (Class<IChannelHandler> clazz : config.getChannelHandlerClass()) {
            IChannelHandler channelHandler = (IChannelHandler)ClassUtil.instance(clazz);
            GettyCommon.init(channelHandler, server, config);
            pipeline.addLast(config.getServiceHandlerLoopGroup(), "service-" + ++index, (ChannelHandler)channelHandler);
        }
    }
}

