/*
 * Decompiled with CFR 0.152.
 */
package cn.godmao.executor;

import cn.godmao.core.IExecute;
import cn.godmao.core.INext;
import cn.godmao.core.ISelector;
import cn.godmao.core.ISubmit;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public interface IExecutorService<E extends ExecutorService>
extends IExecute<E>,
ISubmit<E>,
ISelector<E>,
INext<E> {
    public E[] getExecutors();

    public boolean isTerminated();

    public boolean isShutdown();

    public void shutdown();

    default public void execute(Object key, Runnable runnable) {
        this.execute((Executor)this.select(key), runnable);
    }

    default public Future<?> submit(Object key, Runnable runnable) {
        return this.submit((ExecutorService)this.select(key), runnable);
    }

    default public <T> Future<T> submit(Object key, Runnable task, T result) {
        return this.submit((ExecutorService)this.select(key), task, result);
    }

    default public <T> Future<T> submit(Object key, Callable<T> task) {
        return this.submit((ExecutorService)this.select(key), task);
    }

    default public E select(Object key) {
        if (null == key) {
            return (E)((ExecutorService)this.next());
        }
        return (E)this.getExecutors()[Math.abs(key.hashCode() % this.getExecutors().length)];
    }
}

