/*
 * Decompiled with CFR 0.152.
 */
package cn.godmao.executor;

import cn.godmao.executor.IExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;

public abstract class AbstractExecutorService<E extends ExecutorService>
implements IExecutorService<E> {
    protected final AtomicLong counter = new AtomicLong();
    protected E[] executors;
    protected String thread_name;

    public AbstractExecutorService(E[] executors) {
        this(null, (ExecutorService[])executors);
    }

    public AbstractExecutorService(String thread_name, E[] executors) {
        this.executors = executors;
        this.thread_name = thread_name;
    }

    public AtomicLong getCounter() {
        return this.counter;
    }

    public String getThreadName() {
        return this.thread_name;
    }

    @Override
    public boolean isTerminated() {
        boolean isTerminated = true;
        for (ExecutorService executor : this.getExecutors()) {
            if (executor.isTerminated()) continue;
            isTerminated = false;
            break;
        }
        return isTerminated;
    }

    @Override
    public boolean isShutdown() {
        boolean isShutdown = true;
        for (ExecutorService executor : this.getExecutors()) {
            if (executor.isShutdown()) continue;
            isShutdown = false;
            break;
        }
        return isShutdown;
    }

    @Override
    public void shutdown() {
        for (ExecutorService executor : this.getExecutors()) {
            executor.shutdown();
        }
    }

    @Override
    public E[] getExecutors() {
        return this.executors;
    }

    public E next() {
        return (E)this.getExecutors()[Math.abs((int)(this.getCounter().incrementAndGet() % (long)this.getExecutors().length))];
    }

    public void execute(Runnable runnable) {
        this.execute((Executor)this.next(), runnable);
    }

    public Future<?> submit(Runnable task) {
        return this.submit((ExecutorService)this.next(), task);
    }

    public <T> Future<T> submit(Runnable task, T result) {
        return this.submit((ExecutorService)this.next(), task, result);
    }

    public <T> Future<T> submit(Callable<T> task) {
        return this.submit((ExecutorService)this.next(), task);
    }
}

