package cn.godmao.executor;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public class DefaultExecutorService extends AbstractExecutorService<ExecutorService> {

    public DefaultExecutorService(String thread_name, ExecutorService[] executorService) {
        super(thread_name, executorService);
    }

    public DefaultExecutorService(String thread_name) {
        this(thread_name, Runtime.getRuntime().availableProcessors());
    }

    public DefaultExecutorService(String thread_name, int threads) {
        this(thread_name, new ExecutorService[threads]);
        init();
    }

    public DefaultExecutorService(ExecutorService[] executorService) {
        super(executorService);
    }

    public DefaultExecutorService() {
        this(Runtime.getRuntime().availableProcessors());
    }

    public DefaultExecutorService(int threads) {
        this(new ExecutorService[threads]);
        init();
    }


    private void init() {
        ThreadFactory factory;
        if (null == getThreadName()) {
            factory = ThreadFactoryBuilder.create().setNamePrefix(this.getClass()).build();
        } else {
            factory = ThreadFactoryBuilder.create().setNamePrefix(getThreadName()).build();
        }
        for (int i = 0; i < getExecutors().length; i++) {
            getExecutors()[i] = Executors.newSingleThreadExecutor(factory);
        }
    }

}
