package cn.godmao.executor;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public class DefaultExecutorGroup extends AbstractExecutorGroup<ExecutorService> {

    public DefaultExecutorGroup(String thread_name, ExecutorService[] executorService) {
        super(thread_name, executorService);
    }

    public DefaultExecutorGroup(String thread_name) {
        this(thread_name, Runtime.getRuntime().availableProcessors());
    }

    public DefaultExecutorGroup(String thread_name, int threads) {
        this(thread_name, new ExecutorService[threads]);
        init();
    }

    public DefaultExecutorGroup(ExecutorService[] executorService) {
        super(executorService);
    }

    public DefaultExecutorGroup() {
        this(Runtime.getRuntime().availableProcessors());
    }

    public DefaultExecutorGroup(int threads) {
        this(new ExecutorService[threads]);
        init();
    }


    private void init() {
        ThreadFactory factory;
        if (null == getThreadName()) {
            factory = ThreadFactoryBuilder.create().setNamePrefix(this.getClass()).build();
        } else {
            factory = ThreadFactoryBuilder.create().setNamePrefix(getThreadName()).build();
        }
        for (int i = 0; i < getExecutors().length; i++) {
            getExecutors()[i] = Executors.newSingleThreadExecutor(factory);
        }
    }

}
