package cn.godmao.executor;

import cn.godmao.common.IExecute;
import cn.godmao.common.IRunnable;
import java.util.*;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;

/**
 * 需要改进
 */
public class TimerService implements ITimerService {
    private final IExecutorService<ExecutorService> executorService;
    private final TaskQueue taskQueue;

    private TimerService(IExecutorService<ExecutorService> executorService) {
        this.executorService = executorService;
        this.taskQueue = new TaskQueue();
    }

    public TimerService() {
        this(new DefaultExecutorService());
    }

    public TaskQueue getTaskQueue() {
        return taskQueue;
    }

    public void schedule(Object name, IRunnable runnable, long delay, long period) {
        taskQueue.add(new TimerTask(name, runnable, delay, period, executorService.select(name)));
    }

    public void schedule(Object name, IRunnable runnable, long delay) {
        schedule(name, runnable, delay, -1L);
    }

    public void schedule(IRunnable runnable, long delay) {
        schedule(UUID.randomUUID().toString(), runnable, delay);
    }

    public void schedule(IRunnable runnable, long delay, long period) {
        schedule(UUID.randomUUID().toString(), runnable, delay, period);
    }


    private static class TaskQueue {
        private final Map<Object, TimerTask> queue;
        private final Timer timer;

        public TaskQueue(Map<Object, TimerTask> queue) {
            this.queue = queue;
            this.timer = new Timer();
        }

        public TaskQueue() {
            this(new ConcurrentHashMap<>());
        }

        public void add(TimerTask timerTask) {
            if (timerTask.getDelay() < 1) {
                throw new RuntimeException("delay 不能小于1");
            }
            if (this.queue.containsKey(timerTask.getKey())) {
                throw new RuntimeException("定时任务: " + timerTask.getKey() + " " + timerTask.getCreatetime() + " 已存在!");
            }
            this.queue.put(timerTask.getKey(), timerTask);

            if (timerTask.getPeriod() > 0) {
                timer.schedule(timerTask, timerTask.getDelay(), timerTask.getPeriod());
            } else {
                timer.schedule(timerTask, timerTask.getDelay());
            }
        }

        public void remove(Object key) {
            final TimerTask timerTask = this.queue.remove(key);
            if (null != timerTask) {
                timerTask.cancel();
            }
        }
    }

    private static class TimerTask extends java.util.TimerTask implements IExecute<Executor> {
        private final Object key;
        private final IRunnable runnable;
        private final long delay;
        private final long period;
        private final long createtime;
        private final Executor executor;
        private long updatetime;

        public TimerTask(Object taskName, IRunnable runnable, Long delay, Long period, Executor executor) {
            this.key = taskName;
            this.runnable = runnable;
            this.delay = delay;
            this.createtime = System.currentTimeMillis();
            this.updatetime = this.createtime;
            this.executor = executor;
            this.period = period;
        }

        public Executor getExecutor() {
            return executor;
        }

        public Long getDelay() {
            return delay;
        }

        public Long getPeriod() {
            return period;
        }


        public Object getKey() {
            return key;
        }

        public IRunnable getRunnable() {
            return runnable;
        }

        public long getCreatetime() {
            return createtime;
        }


        @Override
        public void run() {
            try {
                execute(getRunnable());
            } finally {
                this.updatetime = System.currentTimeMillis();
                if (period <= 0) {
                    me().getTaskQueue().remove(getKey());
                }
            }
        }

        @Override
        public void execute(IRunnable runnable) {
            execute(executor, runnable);
        }
    }

    public static TimerService me() {
        return TimerService.Holder.ME;
    }

    private static class Holder {
        static final TimerService ME = new TimerService();
    }
}
