package cn.godmao.executor;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public class DefaultExecutorService extends AbstractExecutorService<ExecutorService> {

    public DefaultExecutorService(ExecutorService[] executorService) {
        super(executorService);
    }

    public DefaultExecutorService() {
        this(Runtime.getRuntime().availableProcessors());
    }

    public DefaultExecutorService(int threads) {
        this(new ExecutorService[threads]);
        init();
    }


    private void init() {
        final ThreadFactory factory = ThreadFactoryBuilder.create().setNamePrefix(this.getClass()).build();
        for (int i = 0; i < getExecutors().length; i++) {
            getExecutors()[i] = Executors.newSingleThreadExecutor(factory);
        }
    }

}
