/*
 * Decompiled with CFR 0.152.
 */
package cn.godmao.executor;

import cn.godmao.executor.IExecutorService;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;

public abstract class AbstractExecutorService<E extends ExecutorService>
implements IExecutorService<E> {
    protected final AtomicLong counter;
    protected final Random RANDOM = new Random();
    protected E[] executors;

    public AbstractExecutorService(E[] executors) {
        this.counter = new AtomicLong();
        this.executors = executors;
    }

    @Override
    public E[] getExecutors() {
        return this.executors;
    }

    public E next() {
        return (E)this.getExecutors()[Math.abs((int)(this.counter.incrementAndGet() % (long)this.getExecutors().length))];
    }

    public E last() {
        return (E)this.getExecutors()[Math.abs((int)(this.counter.decrementAndGet() % (long)this.getExecutors().length))];
    }

    public E random() {
        return (E)this.getExecutors()[this.RANDOM.nextInt(this.getExecutors().length)];
    }
}

