/*
 * Decompiled with CFR 0.152.
 */
package cn.godmao.executor;

import cn.godmao.common.IExecute;
import cn.godmao.common.IRunnable;
import cn.godmao.executor.DefaultExecutorService;
import cn.godmao.executor.IExecutorService;
import cn.godmao.executor.ITimerService;
import java.util.Map;
import java.util.Timer;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;

public class TimerService
implements ITimerService {
    private final IExecutorService<ExecutorService> executorService;
    private final TaskQueue taskQueue;

    private TimerService(IExecutorService<ExecutorService> executorService) {
        this.executorService = executorService;
        this.taskQueue = new TaskQueue();
    }

    public TimerService() {
        this(new DefaultExecutorService());
    }

    public TaskQueue getTaskQueue() {
        return this.taskQueue;
    }

    @Override
    public void schedule(Object name, IRunnable runnable, long delay, long period) {
        this.taskQueue.add(new TimerTask(name, runnable, delay, period, (Executor)this.executorService.select(name)));
    }

    @Override
    public void schedule(Object name, IRunnable runnable, long delay) {
        this.schedule(name, runnable, delay, -1L);
    }

    @Override
    public void schedule(IRunnable runnable, long delay) {
        this.schedule(UUID.randomUUID().toString(), runnable, delay);
    }

    @Override
    public void schedule(IRunnable runnable, long delay, long period) {
        this.schedule(UUID.randomUUID().toString(), runnable, delay, period);
    }

    public static TimerService me() {
        return Holder.ME;
    }

    private static class TaskQueue {
        private final Map<Object, TimerTask> queue;
        private final Timer timer;

        public TaskQueue(Map<Object, TimerTask> queue) {
            this.queue = queue;
            this.timer = new Timer();
        }

        public TaskQueue() {
            this(new ConcurrentHashMap<Object, TimerTask>());
        }

        public void add(TimerTask timerTask) {
            if (timerTask.getDelay() < 1L) {
                throw new RuntimeException("delay \u4e0d\u80fd\u5c0f\u4e8e1");
            }
            if (this.queue.containsKey(timerTask.getKey())) {
                throw new RuntimeException("\u5b9a\u65f6\u4efb\u52a1: " + timerTask.getKey() + " " + timerTask.getCreatetime() + " \u5df2\u5b58\u5728!");
            }
            this.queue.put(timerTask.getKey(), timerTask);
            if (timerTask.getPeriod() > 0L) {
                this.timer.schedule((java.util.TimerTask)timerTask, timerTask.getDelay(), (long)timerTask.getPeriod());
            } else {
                this.timer.schedule((java.util.TimerTask)timerTask, timerTask.getDelay());
            }
        }

        public void remove(Object key) {
            TimerTask timerTask = this.queue.remove(key);
            if (null != timerTask) {
                timerTask.cancel();
            }
        }
    }

    private static class TimerTask
    extends java.util.TimerTask
    implements IExecute<Executor> {
        private final Object key;
        private final IRunnable runnable;
        private final long delay;
        private final long period;
        private final long createtime;
        private final Executor executor;
        private long updatetime;

        public TimerTask(Object taskName, IRunnable runnable, Long delay, Long period, Executor executor) {
            this.key = taskName;
            this.runnable = runnable;
            this.delay = delay;
            this.updatetime = this.createtime = System.currentTimeMillis();
            this.executor = executor;
            this.period = period;
        }

        public Executor getExecutor() {
            return this.executor;
        }

        public Long getDelay() {
            return this.delay;
        }

        public Long getPeriod() {
            return this.period;
        }

        public Object getKey() {
            return this.key;
        }

        public IRunnable getRunnable() {
            return this.runnable;
        }

        public long getCreatetime() {
            return this.createtime;
        }

        @Override
        public void run() {
            try {
                this.execute(this.getRunnable());
            }
            finally {
                this.updatetime = System.currentTimeMillis();
                if (this.period <= 0L) {
                    TimerService.me().getTaskQueue().remove(this.getKey());
                }
            }
        }

        public void execute(IRunnable runnable) {
            this.execute(this.executor, runnable);
        }
    }

    private static class Holder {
        static final TimerService ME = new TimerService();

        private Holder() {
        }
    }
}

