package cn.godmao.executor;

import cn.godmao.common.IExecute;
import cn.godmao.common.IRunnable;
import cn.godmao.common.ISelector;
import cn.godmao.common.ISubmit;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public interface IExecutorService<E extends ExecutorService> extends IExecute<E>, ISubmit<E>, ISelector<E> {

    E[] getExecutors();


    default boolean isTerminated() {
        boolean isTerminated = true;
        for (E executor : getExecutors()) {
            if (!executor.isTerminated()) {
                isTerminated = false;
                break;
            }
        }
        return isTerminated;
    }

    default boolean isShutdown() {
        boolean isShutdown = true;
        for (E executor : getExecutors()) {
            if (!executor.isShutdown()) {
                isShutdown = false;
                break;
            }
        }
        return isShutdown;
    }


    default void shutdown() {
        for (E executor : getExecutors()) {
            executor.shutdown();
        }
    }


    @Override
    default E select(Object key) {
        if (null == key) {
            return next();
        } else {
            return getExecutors()[Math.abs(key.hashCode() % getExecutors().length)];
        }
    }

    //
    default void execute(Object key, IRunnable runnable) {
        execute(select(key), runnable);
    }

    @Override
    default void execute(IRunnable runnable) {
        execute(next(), runnable);
    }


    //
    default Future<?> submit(Object key, IRunnable runnable) {
        return submit(select(key), runnable);
    }

    default <T> Future<T> submit(Object key, IRunnable task, T result) {
        return submit(select(key), task, result);
    }

    default <T> Future<T> submit(Object key, Callable<T> task) {
        return submit(select(key), task);
    }

    @Override
    default Future<?> submit(IRunnable task) {
        return submit(next(), task);
    }

    @Override
    default <T> Future<T> submit(IRunnable task, T result) {
        return submit(next(), task, result);
    }

    @Override
    default <T> Future<T> submit(Callable<T> task) {
        return submit(next(), task);
    }
}
