package cn.godmao.executor;

import cn.godmao.core.*;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public interface IExecutorService<E extends ExecutorService> extends IExecute<E>, ISubmit<E>, ISelector<E>, INext<E> {

    E[] getExecutors();

    boolean isTerminated();

    boolean isShutdown();

    void shutdown();

    //
    default void execute(Object key, Runnable runnable) {
        execute(select(key), runnable);
    }

    default Future<?> submit(Object key, Runnable runnable) {
        return submit(select(key), runnable);
    }

    default <T> Future<T> submit(Object key, Runnable task, T result) {
        return submit(select(key), task, result);
    }

    default <T> Future<T> submit(Object key, Callable<T> task) {
        return submit(select(key), task);
    }

    @Override
    default E select(Object key) {
        if (null == key) {
            return next();
        } else {
            return getExecutors()[Math.abs(key.hashCode() % getExecutors().length)];
        }
    }
}
