/*
 * Decompiled with CFR 0.152.
 */
package cn.godmao.executor;

import cn.godmao.common.IBuilder;
import java.util.Locale;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;

public class ThreadFactoryBuilder
implements IBuilder<ThreadFactory> {
    private static final long serialVersionUID = 1L;
    private ThreadFactory backingThreadFactory;
    private String namePrefix;
    private Boolean daemon;
    private Integer priority;
    private Thread.UncaughtExceptionHandler uncaughtExceptionHandler;

    public static ThreadFactoryBuilder create() {
        return new ThreadFactoryBuilder();
    }

    public ThreadFactoryBuilder setThreadFactory(ThreadFactory backingThreadFactory) {
        this.backingThreadFactory = backingThreadFactory;
        return this;
    }

    public ThreadFactoryBuilder setNamePrefix(String namePrefix) {
        this.namePrefix = namePrefix;
        return this;
    }

    public ThreadFactoryBuilder setDaemon(boolean daemon) {
        this.daemon = daemon;
        return this;
    }

    public ThreadFactoryBuilder setPriority(int priority) {
        if (priority < 1) {
            throw new IllegalArgumentException("Thread priority (" + priority + ") must be >= 1");
        }
        if (priority > 10) {
            throw new IllegalArgumentException("Thread priority (" + priority + ") must be <= 10");
        }
        this.priority = priority;
        return this;
    }

    public ThreadFactoryBuilder setNamePrefix(Class<?> poolType) {
        if (poolType == null) {
            throw new NullPointerException("poolType");
        }
        Object poolName = poolType.getName();
        int lastDotIdx = ((String)poolName).lastIndexOf(46);
        if (lastDotIdx > -1) {
            poolName = ((String)poolName).substring(lastDotIdx + 1);
        }
        switch (((String)poolName).length()) {
            case 0: {
                poolName = "unknown";
            }
            case 1: {
                poolName = ((String)poolName).toLowerCase(Locale.US);
            }
        }
        if (Character.isUpperCase(((String)poolName).charAt(0)) && Character.isLowerCase(((String)poolName).charAt(1))) {
            poolName = Character.toLowerCase(((String)poolName).charAt(0)) + ((String)poolName).substring(1);
        }
        this.namePrefix = poolName;
        return this;
    }

    public ThreadFactoryBuilder setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
        return this;
    }

    public ThreadFactory build() {
        return ThreadFactoryBuilder.build(this);
    }

    private static ThreadFactory build(ThreadFactoryBuilder builder) {
        ThreadFactory backingThreadFactory = null != builder.backingThreadFactory ? builder.backingThreadFactory : Executors.defaultThreadFactory();
        String namePrefix = builder.namePrefix;
        Boolean daemon = builder.daemon;
        Integer priority = builder.priority;
        Thread.UncaughtExceptionHandler handler = builder.uncaughtExceptionHandler;
        AtomicLong count = null == namePrefix ? null : new AtomicLong();
        return r -> {
            Thread thread = backingThreadFactory.newThread(r);
            if (null != namePrefix) {
                thread.setName(namePrefix + count.getAndIncrement());
            }
            if (null != daemon) {
                thread.setDaemon(daemon);
            }
            if (null != priority) {
                thread.setPriority(priority);
            }
            if (null != handler) {
                thread.setUncaughtExceptionHandler(handler);
            }
            return thread;
        };
    }
}

