package cn.godmao.executor;

import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;

public abstract class AbstractExecutorService<E extends ExecutorService> implements IExecutorService<E> {
    protected final AtomicLong counter;
    protected final Random RANDOM;
    protected E[] executors;

    public AbstractExecutorService(E[] executors) {
        this.RANDOM = new Random();
        this.counter = new AtomicLong();
        this.executors = executors;
    }


    public E[] getExecutors() {
        return executors;
    }


    @Override
    public E next() {
        return getExecutors()[Math.abs((int) (counter.incrementAndGet() % getExecutors().length))];
    }

    @Override
    public E last() {
        return getExecutors()[Math.abs((int) (counter.decrementAndGet() % getExecutors().length))];
    }

    @Override
    public E random() {
        return getExecutors()[RANDOM.nextInt(getExecutors().length)];
    }

}
