package cn.godmao.exception;

public enum Code {
    FAIL(401, "error"),
    SUCCESS(201, "success"),
    ;

    private final int    code;
    private final String msg;

    Code(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public int getCode() {
        return code;
    }

    public String getMsg() {
        return msg;
    }

    public BaseException exception(int code, String msg, Object data) {
        return new BaseException(code, msg, data);
    }

    public BaseException exception(int code, String msg) {
        return exception(code, msg, msg);
    }

    public BaseException exception(String msg) {
        return exception(getCode(), msg);
    }

    public BaseException exception(String msg, Object data) {
        return exception(getCode(), msg, data);
    }

    public BaseException exception(Object data) {
        return exception(getCode(), getMsg(), data);
    }

    public BaseException exception() {
        return exception(getCode(), getMsg());
    }

    public boolean equals(Integer code) {
        return this.code == code;
    }

    public boolean equals(Code code) {
        return this.code == code.getCode();
    }
}
