package cn.godmao.core;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public interface ISubmit<E extends ExecutorService> {
    Future<?> submit(Runnable task);

    <T> Future<T> submit(Runnable task, T result);

    <T> Future<T> submit(Callable<T> task);


    default Future<?> submit(E executor, Runnable task) {
        return executor.submit(task);
    }

    default <T> Future<T> submit(E executor, Runnable task, T result) {
        return executor.submit(task, result);
    }

    default <T> Future<T> submit(E executor, Callable<T> task) {
        return executor.submit(task);
    }
}
