package cn.godmao.core;


import java.io.Serializable;

public interface ICompare<C, T> extends Serializable {
    /**
     * 等于
     */
    <R> C eq(IFunction<T, R> column, R val);

    /**
     * 不等于
     */
    <R> C ne(IFunction<T, R> column, R val);

    /**
     * 大于
     */
    <R> C gt(IFunction<T, R> column, R val);

    /**
     * 大于等于
     */
    <R> C ge(IFunction<T, R> column, R val);

    /**
     * 小于
     */
    <R> C lt(IFunction<T, R> column, R val);

    /**
     * 小于等于
     */
    <R> C le(IFunction<R, T> column, R val);

    /**
     * 或者
     */
    C or();

    /**
     * 并且
     */
    C and();

    <R> C between(IFunction<R, T> column, R val1, R val2);

    <R> C notBetween(IFunction<R, T> column, R val1, R val2);

}
