package cn.godmao.common;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public interface ISchedule {
    ScheduledFuture<?> schedule(IRunnable runnable, long delay);

    ScheduledFuture<?> schedule(IRunnable runnable, long delay, long period);

    default ScheduledFuture<?> schedule(ScheduledExecutorService scheduled, IRunnable runnable, long delay) {
        return scheduled.schedule(runnable, delay, TimeUnit.MILLISECONDS);
    }

    default ScheduledFuture<?> schedule(ScheduledExecutorService scheduled, IRunnable runnable, long delay, long period) {
        return scheduled.scheduleAtFixedRate(runnable, delay, period, TimeUnit.MILLISECONDS);
    }
}
