package cn.godmao.common;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public interface ISubmit<E extends ExecutorService> {
    Future<?> submit(IRunnable task);

    <T> Future<T> submit(IRunnable task, T result);

    <T> Future<T> submit(Callable<T> task);
    

    default Future<?> submit(E executor, IRunnable task) {
        return executor.submit(task);
    }

    default <T> Future<T> submit(E executor, IRunnable task, T result) {
        return executor.submit(task, result);
    }

    default <T> Future<T> submit(E executor, Callable<T> task) {
        return executor.submit(task);
    }
}
