//package cn.godmao.airserver;
//
//
//import cn.godmao.airserver.action.ActionHandler;
//import cn.godmao.exception.IException;
//import cn.godmao.netty.server.AbstractServer;
//import com.alibaba.fastjson2.JSON;
//import io.netty.channel.ChannelHandlerContext;
//import io.netty.util.concurrent.Future;
//
//import java.util.Set;
//
//public class DefaultServer extends AbstractServer {
//
//    public DefaultServer(int port) {
//        super(port);
//    }
//
//    @Override
//    public void onOpen(ChannelHandlerContext ctx) {
//        log.info("连接成功: |{}", ctx.channel().id());
//    }
//
//    @Override
//    public void onClose(ChannelHandlerContext ctx) {
//        log.info("连接关闭: |{}", ctx.channel().id());
//    }
//
//    @Override
//    public void onError(ChannelHandlerContext ctx, Throwable throwable) {
//        log.warn("连接异常: |" + ctx.channel().id(), throwable);
//    }
//
//    @Override
//    public void onMessage(ChannelHandlerContext ctx, Object message_) {
//        Message message = (Message) message_;
//        Set<ActionHandler.Param> params = ActionHandler.me().getParm(message.getData());
//
//        ActionHandler.MethodNode methodNode = ActionHandler.me().match(message.getPath(), params);
//        params.add(new ActionHandler.Param("message", message));
//        params.add(new ActionHandler.Param("data", message.getData()));
//        params.add(new ActionHandler.Param("path", message.getPath()));
//        params.add(new ActionHandler.Param("ctx", ctx));
//        params.add(new ActionHandler.Param("channel", ctx.channel()));
//        params.add(new ActionHandler.Param("id", getChannelService().getChannelId(ctx)));
//
//
//        if (null == methodNode) {
//            log.warn("未知消息: {}", message_);
//            return;
//        }
//        //
//        Future<Object> submit = getChannelService().getChannelExecutor(ctx).submit(() -> methodNode.invoke(params));
//        //
//        submit.addListener(future -> {
//            if (future.isSuccess()) {
//                if (methodNode.hasReturn()) {
//                    getChannelService().writeAndFlush(
//                            ctx,
//                            new Message(
//                                    message.getPath(),
//                                    new ActionHandler.Param("result", JSON.toJSON(future.getNow()))
//                            ));
//                }
//            } else {
//                final Throwable cause = future.cause();
//                int e_code;
//                Object e_data;
//                if (cause.getCause() instanceof IException) {
//                    e_code = ((IException<?>) cause.getCause()).getCode();
//                    e_data = ((IException<?>) cause.getCause()).getData();
//                } else if (cause instanceof IException) {
//                    e_code = ((IException<?>) cause).getCode();
//                    e_data = ((IException<?>) cause).getData();
//                } else {
//                    log.error("SYSTEM ERROR", cause);
//                    return;
//                }
//                getChannelService().writeAndFlush(
//                        ctx,
//                        new Message(
//                                message.getPath(),
//                                new ActionHandler.Param("code", e_code),
//                                new ActionHandler.Param("data", JSON.toJSON(e_data)))
//                );
//            }
//        });
//    }
//
//
//}
